<?php
/**
 * Cancel Membership
 *
 * @package     AutomatorWP\Integrations\ARMember\Actions\Cancel_Membership
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_ARMember_Cancel_Membership extends AutomatorWP_Integration_Action {

    public $integration = 'armember';
    public $action = 'armember_cancel_membership';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Cancel the user\'s membership plan', 'automatorwp-pro' ),
            'select_option'     => __( 'Cancel the user\'s <strong>membership</strong> plan', 'automatorwp-pro' ),
            /* translators: %1$s: Referral. */
            'edit_label'        => sprintf( __( 'Cancel the user\'s %1$s', 'automatorwp-pro' ), '{plan}' ),
            /* translators: %1$s: Referral. */
            'log_label'         => sprintf( __( 'Cancel the user\'s %1$s', 'automatorwp-pro' ), '{plan}' ),
            'options'           => array(
                'plan' => automatorwp_utilities_ajax_selector_option( array(
                    'field'             => 'plan',
                    'option_default'    => __( 'Plan', 'automatorwp-pro' ),
                    'name'              => __( 'Plan:', 'automatorwp-pro' ),                    
                    'action_cb'         => 'automatorwp_armember_get_plans',
                    'options_cb'        => 'automatorwp_armember_options_cb_plan',
                    'placeholder'       => 'Select a plan',
                    'default'           => ''
                ) ),
             ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        global $arm_subscription_plans;

        // Shorthand
        $plan_id = $action_options['plan'];

        // Bail if no plan
        if ( empty ( $plan_id ) ) {
            return;
        }
  
		do_action( 'arm_before_update_user_subscription', $user_id, '0' );
		do_action( 'arm_cancel_subscription', $user_id, $plan_id );
        
        $arm_subscription_plans->arm_add_membership_history( $user_id, $plan_id, 'cancel_subscription' );
		$arm_subscription_plans->arm_clear_user_plan_detail( $user_id, $plan_id );
		update_user_meta( $user_id, 'arm_secondary_status', 6 );

    }

}

new AutomatorWP_ARMember_Cancel_Membership();